/*
 * Decompiled with CFR 0.152.
 */
package com.marth7th.solidarytinker.client.Renderer.Halo;

import com.marth7th.solidarytinker.client.Renderer.Halo.HaloRendererUtil;
import com.marth7th.solidarytinker.client.Renderer.HaloRenderLogic;
import com.marth7th.solidarytinker.register.solidarytinkerModifiers;
import com.marth7th.solidarytinker.solidarytinker;
import com.marth7th.solidarytinker.util.method.ModifierLevel;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;

public enum HaloRendererEnum implements HaloRendererUtil
{
    HOSHINO((Supplier<Modifier>)solidarytinkerModifiers.ABSOLUTEJUSTICE_STATIC_MODIFIER, "hoshino"),
    AZUSA((Supplier<Modifier>)solidarytinkerModifiers.azusaHaloStaticModifier, "azusa"),
    REISA((Supplier<Modifier>)solidarytinkerModifiers.reisaHaloStaticModifier, "reisa"),
    NATSU((Supplier<Modifier>)solidarytinkerModifiers.natsuHaloStaticModifier, "natsu"),
    AL1S((Supplier<Modifier>)solidarytinkerModifiers.al1sHaloStaticModifier, "al1s"),
    MARI((Supplier<Modifier>)solidarytinkerModifiers.mariHaloStaticModifier, "mari");

    private final Supplier<Modifier> modifierSupplier;
    private final ResourceLocation texture;
    private Modifier cachedModifier;

    private HaloRendererEnum(Supplier<Modifier> modifierSupplier, String textureName) {
        this.modifierSupplier = modifierSupplier;
        this.texture = solidarytinker.getResource("textures/halo/" + textureName + ".png");
    }

    public Modifier getModifier() {
        if (this.cachedModifier == null) {
            this.cachedModifier = this.modifierSupplier.get();
        }
        return this.cachedModifier;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    @Nullable
    public ResourceLocation getModelLocation() {
        return null;
    }

    @Override
    public boolean checkClientRenderCondition(Player player) {
        return ModifierLevel.getAllSlotModifierlevel((LivingEntity)player, this.getModifierId()) > 0;
    }

    @Override
    public void render(PoseStack poseStack, Player player, float partialTick) {
        HaloRenderLogic.renderCompleteDynamicHaloHorizontal(poseStack, player, partialTick, this.texture);
    }

    @Override
    public ModifierId getModifierId() {
        return this.getModifier().getId();
    }
}

